/*! firebase-admin v13.6.1 */
"use strict";
/*!
 * @license
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports._validateAdminArgs = _validateAdminArgs;
const index_1 = require("./index");
const data_connect_api_client_internal_1 = require("./data-connect-api-client-internal");
/**
 * @internal
 *
 * The generated Admin SDK will allow the user to pass in variables, a Data Connect
 * instance, or operation options. The only required argument is the variables,
 * which are only required when the operation has at least one required variable.
 * Otherwise, all arguments are optional.
 *
 * This function validates the variables and returns back the DataConnect instance,
 * variables, and options based on the arguments passed in. It always returns a
 * DataConnect instance, using the connectorConfig to grab one if not provided.
 *
 * For this function to work properly, if the operation has variables (optional
 * are required), you must pass hasVars: true (if there are no variables, it is
 * not required, since undefined is false-y).
 *
 * Usage examples can be found in test files.
 *
 * @param connectorConfig - DataConnect connector config
 * @param dcOrVarsOrOptions - the first argument provided to a generated admin function
 * @param varsOrOptions - the second argument provided to a generated admin function
 * @param options - the third argument provided to a generated admin function
 * @param hasVars - boolean parameter indicating whether the operation has variables
 * @param validateVars - boolean parameter indicating whether we should expect to find a value for realVars
 * @returns parsed DataConnect, Variables, and Options for the operation
 */
function _validateAdminArgs(connectorConfig, dcOrVarsOrOptions, varsOrOptions, options, hasVars, validateVars) {
    let dcInstance;
    let realVars;
    let realOptions;
    if (dcOrVarsOrOptions && 'connectorConfig' in dcOrVarsOrOptions) {
        dcInstance = dcOrVarsOrOptions;
        if (hasVars) {
            realVars = varsOrOptions;
            realOptions = options;
        }
        else {
            realVars = undefined;
            realOptions = varsOrOptions;
        }
    }
    else {
        dcInstance = (0, index_1.getDataConnect)(connectorConfig);
        if (hasVars) {
            realVars = dcOrVarsOrOptions;
            realOptions = varsOrOptions;
        }
        else {
            realVars = undefined;
            realOptions = dcOrVarsOrOptions;
        }
    }
    if (!dcInstance || (!realVars && validateVars)) {
        throw new data_connect_api_client_internal_1.FirebaseDataConnectError(data_connect_api_client_internal_1.DATA_CONNECT_ERROR_CODE_MAPPING.INVALID_ARGUMENT, 'Variables required.');
    }
    return { dc: dcInstance, vars: realVars, options: realOptions };
}
